//------------------------------------------------------------------------------
// File: svr_taskconversions.cs
// This file is used for converting various task values to other values
// Author: Matthew Rudge
//------------------------------------------------------------------------------

//-Constants and Globals--------------------------------------------------------
// Function type to message type map
$TSC_FCNTMSG[$TSF_SELECT]       = $MSG_SLGOBJSELECT;
$TSC_FCNTMSG[$TSF_CREATE]       = $MSG_SLGOBJCREATE;
$TSC_FCNTMSG[$TSF_DESTROY]      = $MSG_SLGOBJDESTROY;
$TSC_FCNTMSG[$TSF_ZONE]         = $MSG_SLGOBJZONE;
$TSC_FCNTMSG[$TSF_EMPLOY]       = $MSG_SLGOBJEMPLOY;
$TSC_FCNTMSG[$TSF_QUIT]         = $MSG_SLGOBJQUIT;
$TSC_FCNTMSG[$TSF_PICKUP]       = $MSG_SLGOBJPICKUP;
$TSC_FCNTMSG[$TSF_QUICKJOB]     = $MSG_SLGOBJQUICKJOB;
$TSC_FCNTMSG[$TSF_REPAIR]       = $MSG_SLGOBJREPAIR;
$TSC_FCNTMSG[$TSF_TOOLUSE]      = $MSG_TOOLUSE;
$TSC_FCNTMSG[$TSF_TOOLPURCHASE] = $MSG_TOOLPURCHASE;
$TSC_FCNTMSG[$TSF_TIMERFIRE]    = $MSG_TIMERFIRE;
$TSC_FCNTMSG[$TSF_REFORM]       = $MSG_SLGOBJREFORM;
$TSC_FCNTMSG[$TSF_DIALOGDONE]   = $MSG_DIALOGDONE;
$TSC_FCNTMSG[$TSF_XPBUY]        = $MSG_XPBUY;
$TSC_FCNTMSG[$TSF_MOVE]         = $MSG_SLGOBJMOVE;
$TSC_FCNTMSG[$TSF_TEAMCHANGE]   = $MSG_SLGOBJTEAMCHANGE;

// Message type to function type map
$TSC_MSGTFCN[$MSG_SLGOBJSELECT]   = $TSF_SELECT;
$TSC_MSGTFCN[$MSG_SLGOBJCREATE]   = $TSF_CREATE;
$TSC_MSGTFCN[$MSG_SLGOBJDESTROY]  = $TSF_DESTROY;
$TSC_MSGTFCN[$MSG_SLGOBJZONE]     = $TSF_ZONE;
$TSC_MSGTFCN[$MSG_SLGOBJEMPLOY]   = $TSF_EMPLOY;
$TSC_MSGTFCN[$MSG_SLGOBJQUIT]     = $TSF_QUIT;
$TSC_MSGTFCN[$MSG_SLGOBJPICKUP]   = $TSF_PICKUP;
$TSC_MSGTFCN[$MSG_SLGOBJQUICKJOB] = $TSF_QUICKJOB;
$TSC_MSGTFCN[$MSG_SLGOBJREPAIR]   = $TSF_REPAIR;
$TSC_MSGTFCN[$MSG_TOOLUSE]        = $TSF_TOOLUSE;
$TSC_MSGTFCN[$MSG_TOOLPURCHASE]   = $TSF_TOOLPURCHASE;
$TSC_MSGTFCN[$MSG_TIMERFIRE]      = $TSF_TIMERFIRE;
$TSC_MSGTFCN[$MSG_SLGOBJREFORM]   = $TSF_REFORM;
$TSC_MSGTFCN[$MSG_DIALOGDONE]     = $TSF_DIALOGDONE;
$TSC_MSGTFCN[$MSG_XPBUY]          = $TSF_XPBUY;
$TSC_MSGTFCN[$MSG_SLGOBJMOVE]     = $TSF_MOVE;
$TSC_MSGTFCN[$MSG_SLGOBJTEAMCHANGE] = $TSF_TEAMCHANGE;
//------------------------------------------------------------------------------

//-Functions--------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Converts a task function type to a message type
//! \param %functionType Function type to convert
////////////////////////////////////////////////////////////////////////////////
function tsFunctionToMessage(%functionType)
{
   if($TSC_FCNTMSG[%functionType] !$= "") {
      return $TSC_FCNTMSG[%functionType];
   }
   else {
      return $MSG_INVALID;
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Converts a message type to a task function type
//! \param %msgType Message type to convert
////////////////////////////////////////////////////////////////////////////////
function tsMessageToFunction(%msgType)
{
   if($TSC_MSGTFCN[%msgType] !$= "") {
      return $TSC_MSGTFCN[%msgType];
   }
   else {
      return $TSF_INVALID;
   }
}

////////////////////////////////////////////////////////////////////////////////
//! Converts a string to the equivalent task function type
//! \param %string String value for task function type
////////////////////////////////////////////////////////////////////////////////
function tsStringToFunction(%string)
{
   switch$(%string)
   {
      case "select":
         return $TSF_SELECT;
      case "create":
         return $TSF_CREATE;
      case "destroy":
         return $TSF_DESTROY;
      case "zone":
         return $TSF_ZONE;
      case "employ":
         return $TSF_EMPLOY;
      case "quit":
         return $TSF_QUIT;
      case "pickup":
         return $TSF_PICKUP;
      case "quickjob":
         return $TSF_QUICKJOB;
      case "repair":
         return $TSF_REPAIR;
      case "usetool":
         return $TSF_TOOLUSE;
      case "purchasetool":
         return $TSF_TOOLPURCHASE;
      case "timerfire":
         return $TSF_TIMERFIRE;
      case "reform":
         return $TSF_REFORM;
      case "dialogdone":
         return $TSF_DIALOGDONE;
      case "xpbuy":
         return $TSF_XPBUY;
      case "move":
         return $TSF_MOVE;
      case "teamchange":
         return $TSF_TEAMCHANGE;
   }
   return $TSF_INVALID;
}

////////////////////////////////////////////////////////////////////////////////
//! Converts a string to the equivalent task info pair type
//! \param %string String value for task info pair type
////////////////////////////////////////////////////////////////////////////////
function tsStringToInfoType(%string)
{
   switch$(%string)
   {
      case "objecttype":
         return $TSI_SLGOBJTYPE;
      case "chartype":
         return $TSI_SLGCHARTYPE;
      case "bldgtype":
         return $TSI_SLGBLDGTYPE;
      case "proptype":
         return $TSI_SLGPROPTYPE;
      case "objectname":
         return $TSI_SLGOBJNAME;
      case "charname":
         return $TSI_SLGCHARNAME;
      case "bldgname":
         return $TSI_SLGBLDGNAME;
      case "propname":
         return $TSI_SLGPROPNAME;
      case "zonename":
         return $TSI_ZONENAME;
      case "tooltype":
         return $TSI_TOOLTYPE;
      case "dialogid":
         return $TSI_DIALOGID;
      case "xpname":
         return $TSI_XPNAME;
      case "movetype":
         return $TSI_SLGMOVETYPE;
      case "movename":
         return $TSI_SLGMOVENAME;
      case "targettype":
         return $TSI_SLGTARGETTYPE;
      case "targetname":
         return $TSI_SLGTARGETNAME;
      case "team":
         return $TSI_TEAM;
      case "time":
         return $TSI_TIME;
      case "oldteam":
         return $TSI_OLDTEAM;
      case "newteam":
         return $TSI_NEWTEAM;
   }
   return $TSI_INVALID;
}

//------------------------------------------------------------------------------

// End svr_taskconversions.cs